#include <stdio.h>
#include <string.h>
#include "esp_system.h"
#include "mcpwm.h"
#include "kidbright32.h"
#include "l298n_m2.h"

#define L298N_M2_IN1_GPIO		IN1_GPIO
#define L298N_M2_IN2_GPIO		IN2_GPIO

// pwm unit (MCPWM_UNIT_0 reserved for buzzer output)
#define L298N_M2_MCPWM_UNIT		MCPWM_UNIT_1
// pwm frequency
#define L298N_PWM_FREQ			100
// minimum driving duty cycle
#define DUTY_MIN				30
#define DUTY_MAX				100

L298N_M2::L298N_M2(void) {
	// check CONFIG_FREERTOS_HZ	
	//printf("CONFIG_FREERTOS_HZ = %d\n", CONFIG_FREERTOS_HZ);
}

void L298N_M2::init_gpio(gpio_num_t gpio, int val) {
	gpio_config_t io_conf;

	io_conf.intr_type = GPIO_INTR_DISABLE; // disable interrupt
	io_conf.mode = GPIO_MODE_OUTPUT; //set as output mode
	io_conf.pin_bit_mask = (1ULL << gpio); // bit mask of the pins that you want to set
	io_conf.pull_down_en = GPIO_PULLDOWN_DISABLE; // disable pull-down mode
	io_conf.pull_up_en = GPIO_PULLUP_DISABLE; // disable pull-up mode
	gpio_set_level(gpio, val); // load gpio value
	gpio_config(&io_conf);
}

void L298N_M2::l298n_m2_stop(void) {
	// fast motor stop IN1=1, IN2=1
	 init_gpio(L298N_M2_IN1_GPIO, 1);
	 init_gpio(L298N_M2_IN2_GPIO, 1);
}

int L298N_M2::cmpr_calc(int duty) {
	if (duty < 0) {
		duty = (-1 * duty);
	}

	if (duty < DUTY_MIN) {
		duty = DUTY_MIN;
	}

	if (duty >= 100) {
		duty = DUTY_MAX;
	}

	return (100 - duty);
}

/*void L298N_M2::l298n_m2_pwm_ab(int da, int db) {
	mcpwm_pin_config_t pin_config;
	mcpwm_config_t pwm_config;
	bool a_flag, b_flag;

	a_flag = false;
	b_flag = false;

	// mcpwm gpio initialization
	memset(&pin_config, 0, sizeof(mcpwm_pin_config_t));

	// fixed missing output update
	//if (da != duty_a) {
		if (da != 0) {
			pin_config.mcpwm0a_out_num = (da > 0 ? GPIO_A1 : GPIO_A2);
			a_flag = true;
		}
		else {
			// da = 0, stop motor
			l298n_m2_stop_a();
			// update new duty cycle
			duty_a = da;
		}
	//}

	// fixed missing output update
	//if (db != duty_b) {
		if (db != 0) {
			//pin_config.mcpwm0b_out_num = (db > 0 ? GPIO_B1 : GPIO_B2);
			pin_config.mcpwm1a_out_num = (db > 0 ? GPIO_B1 : GPIO_B2);
			b_flag = true;
		}
		else {
			// db = 0, stop motor
			l298n_m2_stop_b();
			// update new duty cycle
			duty_b = db;
		}
	//}

	// if at least one duty cycle change
	if (a_flag || b_flag) {
		mcpwm_set_pin(L298N_M2_MCPWM_UNIT, &pin_config);

		if (a_flag) {
			// mcpwm config initialization
			memset(&pwm_config, 0, sizeof(mcpwm_config_t));
			// initialize mcpwm configuration
			pwm_config.frequency = 1000; // frequency = 1000Hz
			pwm_config.cmpr_a = cmpr_calc(da); // calc compare value for specific duty cycle of PWM0A
			pwm_config.counter_mode = MCPWM_UP_COUNTER;
			pwm_config.duty_mode = (pin_config.mcpwm0a_out_num == GPIO_A1 ? MCPWM_DUTY_MODE_0 : MCPWM_DUTY_MODE_1); // set duty cycle phrase to normal or inverted
			mcpwm_init(L298N_M2_MCPWM_UNIT, MCPWM_TIMER_0, &pwm_config);   // configure PWM0A above settings

			// update new duty cycle
			duty_a = da;
		}

		if (b_flag) {
			// mcpwm config initialization
			memset(&pwm_config, 0, sizeof(mcpwm_config_t));
			// initialize mcpwm configuration
			pwm_config.frequency = 1000; // frequency = 1000Hz
			pwm_config.cmpr_a = cmpr_calc(db); // calc compare value for specific duty cycle of PWM0B
			pwm_config.counter_mode = MCPWM_UP_COUNTER;
			pwm_config.duty_mode = (pin_config.mcpwm1a_out_num == GPIO_B1 ? MCPWM_DUTY_MODE_0 : MCPWM_DUTY_MODE_1); // set duty cycle phrase to normal or inverted
			mcpwm_init(L298N_M2_MCPWM_UNIT, MCPWM_TIMER_1, &pwm_config);   // configure PWM0A above settings

			// update new duty cycle
			duty_b = db;
		}
	}
}*/

void L298N_M2::init(void) {
	// stop motor
	l298n_m2_stop();

	state = s_detect;
}

int L298N_M2::prop_count(void) {
	// not supported
	return 0;
}

bool L298N_M2::prop_name(int index, char *name) {
	// not supported
	return false;
}

bool L298N_M2::prop_unit(int index, char *unit) {
	// not supported
	return false;
}

bool L298N_M2::prop_attr(int index, char *attr) {
	// not supported
	return false;
}

bool L298N_M2::prop_read(int index, char *value) {
	// not supported
	return false;
}

bool L298N_M2::prop_write(int index, char *value) {
	// not supported
	return false;
}

void L298N_M2::process(Driver *drv) {

	switch (state) {
		case s_detect:
			// clear error flag
			error = false;
			// set initialized flag
			initialized = true;

			state = s_idle;
			break;

		case s_idle:
			//
			break;

		case s_error:
			// set error flag
			error = true;
			// clear initialized flag
			initialized = false;
			// get current tickcnt
			tickcnt = get_tickcnt();
			// goto wait and retry with detect state
			state = s_wait;
			break;

		case s_wait:
			// delay 1000ms before retry detect
			if (is_tickcnt_elapsed(tickcnt, 1000)) {
				state = s_detect;
			}
			break;
	}
}

void L298N_M2::spin(int speed) {
	mcpwm_pin_config_t pin_config;
	mcpwm_config_t pwm_config;
	gpio_num_t pwm_gpio, high_gpio;

	pwm_gpio = L298N_M2_IN2_GPIO;
	high_gpio = L298N_M2_IN1_GPIO;

	// speed <= 0, stop motor
	if (speed <= 0) {
		l298n_m2_stop();
	}
	else
	if (speed == 100) {
		init_gpio(pwm_gpio, 0);
		init_gpio(high_gpio, 1);
	}
	else {
		// mcpwm gpio initialization
		memset(&pin_config, 0, sizeof(mcpwm_pin_config_t));
		// set pwm out pin
		pin_config.mcpwm0a_out_num = pwm_gpio;
		mcpwm_set_pin(L298N_M2_MCPWM_UNIT, &pin_config);

		// mcpwm config initialization
		memset(&pwm_config, 0, sizeof(mcpwm_config_t));
		// initialize mcpwm configuration
		pwm_config.frequency = L298N_PWM_FREQ;
		pwm_config.cmpr_a = cmpr_calc(speed); // calc compare value for specific duty cycle of PWM0A
		pwm_config.counter_mode = MCPWM_UP_COUNTER;
		pwm_config.duty_mode = MCPWM_DUTY_MODE_0; // set duty cycle phrase to normal
		mcpwm_init(L298N_M2_MCPWM_UNIT, MCPWM_TIMER_0, &pwm_config); // configure PWM0A above settings

		init_gpio(high_gpio, 1);
	}
}

void L298N_M2::stop(void) {
	// stop motor drive
	l298n_m2_stop();
}

