#include <stdio.h>
#include <string.h>
#include "esp_system.h"
#include "kidbright32.h"
#include "oled_sh1106.h"

// oled registers
#define OLED_REG_DISPLAY_OFF				0xAE
#define OLED_REG_DISPLAY_ON					0xAF
#define OLED_REG_DISPLAYALLON_RESUME		0xA4
#define OLED_REG_DISPLAYALLON				0xA5
#define OLED_REG_NORMAL_DISPLAY				0xA6
#define OLED_REG_INVERSE_DISPLAY			0xA7
#define OLED_REG_CONTRAST_LEVEL				0x81
#define OLED_REG_DISPLAY_OFFSET				0xD3
#define OLED_REG_COMPINS					0xDA
#define OLED_REG_VCOM_DETECT				0xDB
#define OLED_REG_DISPLAY_CLOCKDIV			0xD5
#define OLED_REG_PRECHARGE					0xD9
#define OLED_REG_MULTIPLEX					0xA8
#define OLED_REG_LOW_COLUMN					0x00
#define OLED_REG_HIGH_COLUMN				0x10
#define OLED_REG_SETSTARTLINE				0x40
#define OLED_REG_MEMORY_MODE				0x20
#define OLED_REG_COMSCAN_INC				0xC0
#define OLED_REG_COMSCAN_DEC				0xC8
#define OLED_REG_SEG_REMAP					0xA0
#define OLED_REG_CHARGE_PUMP				0x8D
#define OLED_REG_SET_PAGEADDR				0xB0

#define OLED_I2C_RENDER_FLAG				0x01

const char oled_font_6_8[] = {
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x00
	0x00,0x3E,0x45,0x51,0x45,0x3E,        // 0x01
	0x00,0x3E,0x6B,0x6F,0x6B,0x3E,        // 0x02
	0x00,0x1C,0x3E,0x7C,0x3E,0x1C,        // 0x03
	0x00,0x18,0x3C,0x7E,0x3C,0x18,        // 0x04
	0x00,0x30,0x36,0x7F,0x36,0x30,        // 0x05
	0x00,0x18,0x5C,0x7E,0x5C,0x18,        // 0x06
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x07
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x08
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x09
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x0A
	0x00,0x30,0x48,0x4A,0x36,0x0E,        // 0x0B
	0x00,0x06,0x29,0x79,0x29,0x06,        // 0x0C
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x0D
	0x00,0x60,0x7E,0x0A,0x35,0x3F,        // 0x0E
	0x00,0x2A,0x1C,0x36,0x1C,0x2A,        // 0x0F
	0x00,0x00,0x7F,0x3E,0x1C,0x08,        // 0x10
	0x00,0x08,0x1C,0x3E,0x7F,0x00,        // 0x11
	0x00,0x14,0x36,0x7F,0x36,0x14,        // 0x12
	0x00,0x00,0x5F,0x00,0x5F,0x00,        // 0x13
	0x00,0x06,0x09,0x7F,0x01,0x7F,        // 0x14
	0x00,0x22,0x4D,0x55,0x59,0x22,        // 0x15
	0x00,0x60,0x60,0x60,0x60,0x00,        // 0x16
	0x00,0x14,0xB6,0xFF,0xB6,0x14,        // 0x17
	0x00,0x04,0x06,0x7F,0x06,0x04,        // 0x18
	0x00,0x10,0x30,0x7F,0x30,0x10,        // 0x19
	0x00,0x08,0x08,0x3E,0x1C,0x08,        // 0x1A
	0x00,0x08,0x1C,0x3E,0x08,0x08,        // 0x1B
	0x00,0x78,0x40,0x40,0x40,0x40,        // 0x1C
	0x00,0x08,0x3E,0x08,0x3E,0x08,        // 0x1D
	0x00,0x30,0x3C,0x3F,0x3C,0x30,        // 0x1E
	0x00,0x03,0x0F,0x3F,0x0F,0x03,        // 0x1F
	0x00,0x00,0x00,0x00,0x00,0x00,        // 0x20
	0x00,0x00,0x06,0x5F,0x06,0x00,        // 0x21
	0x00,0x07,0x03,0x00,0x07,0x03,        // 0x22
	0x00,0x24,0x7E,0x24,0x7E,0x24,        // 0x23
	0x00,0x24,0x2B,0x6A,0x12,0x00,        // 0x24
	0x00,0x63,0x13,0x08,0x64,0x63,        // 0x25
	0x00,0x36,0x49,0x56,0x20,0x50,        // 0x26
	0x00,0x00,0x07,0x03,0x00,0x00,        // 0x27
	0x00,0x00,0x3E,0x41,0x00,0x00,        // 0x28
	0x00,0x00,0x41,0x3E,0x00,0x00,        // 0x29
	0x00,0x08,0x3E,0x1C,0x3E,0x08,        // 0x2A
	0x00,0x08,0x08,0x3E,0x08,0x08,        // 0x2B
	0x00,0x00,0xE0,0x60,0x00,0x00,        // 0x2C
	0x00,0x08,0x08,0x08,0x08,0x08,        // 0x2D
	0x00,0x00,0x60,0x60,0x00,0x00,        // 0x2E
	0x00,0x20,0x10,0x08,0x04,0x02,        // 0x2F
	0x00,0x3E,0x51,0x49,0x45,0x3E,        // 0x30
	0x00,0x00,0x42,0x7F,0x40,0x00,        // 0x31
	0x00,0x62,0x51,0x49,0x49,0x46,        // 0x32
	0x00,0x22,0x49,0x49,0x49,0x36,        // 0x33
	0x00,0x18,0x14,0x12,0x7F,0x10,        // 0x34
	0x00,0x2F,0x49,0x49,0x49,0x31,        // 0x35
	0x00,0x3C,0x4A,0x49,0x49,0x30,        // 0x36
	0x00,0x01,0x71,0x09,0x05,0x03,        // 0x37
	0x00,0x36,0x49,0x49,0x49,0x36,        // 0x38
	0x00,0x06,0x49,0x49,0x29,0x1E,        // 0x39
	0x00,0x00,0x6C,0x6C,0x00,0x00,        // 0x3A
	0x00,0x00,0xEC,0x6C,0x00,0x00,        // 0x3B
	0x00,0x08,0x14,0x22,0x41,0x00,        // 0x3C
	0x00,0x24,0x24,0x24,0x24,0x24,        // 0x3D
	0x00,0x00,0x41,0x22,0x14,0x08,        // 0x3E
	0x00,0x02,0x01,0x59,0x09,0x06,        // 0x3F
	0x00,0x3E,0x41,0x5D,0x55,0x1E,        // 0x40
	0x00,0x7E,0x11,0x11,0x11,0x7E,        // 0x41
	0x00,0x7F,0x49,0x49,0x49,0x36,        // 0x42
	0x00,0x3E,0x41,0x41,0x41,0x22,        // 0x43
	0x00,0x7F,0x41,0x41,0x41,0x3E,        // 0x44
	0x00,0x7F,0x49,0x49,0x49,0x41,        // 0x45
	0x00,0x7F,0x09,0x09,0x09,0x01,        // 0x46
	0x00,0x3E,0x41,0x49,0x49,0x7A,        // 0x47
	0x00,0x7F,0x08,0x08,0x08,0x7F,        // 0x48
	0x00,0x00,0x41,0x7F,0x41,0x00,        // 0x49
	0x00,0x30,0x40,0x40,0x40,0x3F,        // 0x4A
	0x00,0x7F,0x08,0x14,0x22,0x41,        // 0x4B
	0x00,0x7F,0x40,0x40,0x40,0x40,        // 0x4C
	0x00,0x7F,0x02,0x04,0x02,0x7F,        // 0x4D
	0x00,0x7F,0x02,0x04,0x08,0x7F,        // 0x4E
	0x00,0x3E,0x41,0x41,0x41,0x3E,        // 0x4F
	0x00,0x7F,0x09,0x09,0x09,0x06,        // 0x50
	0x00,0x3E,0x41,0x51,0x21,0x5E,        // 0x51
	0x00,0x7F,0x09,0x09,0x19,0x66,        // 0x52
	0x00,0x26,0x49,0x49,0x49,0x32,        // 0x53
	0x00,0x01,0x01,0x7F,0x01,0x01,        // 0x54
	0x00,0x3F,0x40,0x40,0x40,0x3F,        // 0x55
	0x00,0x1F,0x20,0x40,0x20,0x1F,        // 0x56
	0x00,0x3F,0x40,0x3C,0x40,0x3F,        // 0x57
	0x00,0x63,0x14,0x08,0x14,0x63,        // 0x58
	0x00,0x07,0x08,0x70,0x08,0x07,        // 0x59
	0x00,0x71,0x49,0x45,0x43,0x00,        // 0x5A
	0x00,0x00,0x7F,0x41,0x41,0x00,        // 0x5B
	0x00,0x02,0x04,0x08,0x10,0x20,        // 0x5C
	0x00,0x00,0x41,0x41,0x7F,0x00,        // 0x5D
	0x00,0x04,0x02,0x01,0x02,0x04,        // 0x5E
	0x80,0x80,0x80,0x80,0x80,0x80,        // 0x5F
	0x00,0x00,0x03,0x07,0x00,0x00,        // 0x60
	0x00,0x20,0x54,0x54,0x54,0x78,        // 0x61
	0x00,0x7F,0x44,0x44,0x44,0x38,        // 0x62
	0x00,0x38,0x44,0x44,0x44,0x28,        // 0x63
	0x00,0x38,0x44,0x44,0x44,0x7F,        // 0x64
	0x00,0x38,0x54,0x54,0x54,0x08,        // 0x65
	0x00,0x08,0x7E,0x09,0x09,0x00,        // 0x66
	0x00,0x18,0xA4,0xA4,0xA4,0x7C,        // 0x67
	0x00,0x7F,0x04,0x04,0x78,0x00,        // 0x68
	0x00,0x00,0x00,0x7D,0x40,0x00,        // 0x69
	0x00,0x40,0x80,0x84,0x7D,0x00,        // 0x6A
	0x00,0x7F,0x10,0x28,0x44,0x00,        // 0x6B
	0x00,0x00,0x00,0x7F,0x40,0x00,        // 0x6C
	0x00,0x7C,0x04,0x18,0x04,0x78,        // 0x6D
	0x00,0x7C,0x04,0x04,0x78,0x00,        // 0x6E
	0x00,0x38,0x44,0x44,0x44,0x38,        // 0x6F
	0x00,0xFC,0x44,0x44,0x44,0x38,        // 0x70
	0x00,0x38,0x44,0x44,0x44,0xFC,        // 0x71
	0x00,0x44,0x78,0x44,0x04,0x08,        // 0x72
	0x00,0x08,0x54,0x54,0x54,0x20,        // 0x73
	0x00,0x04,0x3E,0x44,0x24,0x00,        // 0x74
	0x00,0x3C,0x40,0x20,0x7C,0x00,        // 0x75
	0x00,0x1C,0x20,0x40,0x20,0x1C,        // 0x76
	0x00,0x3C,0x60,0x30,0x60,0x3C,        // 0x77
	0x00,0x6C,0x10,0x10,0x6C,0x00,        // 0x78
	0x00,0x9C,0xA0,0x60,0x3C,0x00,        // 0x79
	0x00,0x64,0x54,0x54,0x4C,0x00,        // 0x7A
	0x00,0x08,0x3E,0x41,0x41,0x00,        // 0x7B
	0x00,0x00,0x00,0x77,0x00,0x00,        // 0x7C
	0x00,0x00,0x41,0x41,0x3E,0x08,        // 0x7D
	0x00,0x02,0x01,0x02,0x01,0x00,        // 0x7E
	0x00,0x3C,0x26,0x23,0x26,0x3C,        // 0x7F
	0x00,0x1E,0xA1,0xE1,0x21,0x12,        // 0x80
	0x00,0x3D,0x40,0x20,0x7D,0x00,        // 0x81
	0x00,0x38,0x54,0x54,0x55,0x09,        // 0x82
	0x00,0x20,0x55,0x55,0x55,0x78,        // 0x83
	0x00,0x20,0x55,0x54,0x55,0x78,        // 0x84
	0x00,0x20,0x55,0x55,0x54,0x78,        // 0x85
	0x00,0x20,0x57,0x55,0x57,0x78,        // 0x86
	0x00,0x1C,0xA2,0xE2,0x22,0x14,        // 0x87
	0x00,0x38,0x55,0x55,0x55,0x08,        // 0x88
	0x00,0x38,0x55,0x54,0x55,0x08,        // 0x89
	0x00,0x38,0x55,0x55,0x54,0x08,        // 0x8A
	0x00,0x00,0x01,0x7C,0x41,0x00,        // 0x8B
	0x00,0x00,0x01,0x7D,0x41,0x00,        // 0x8C
	0x00,0x00,0x01,0x7C,0x40,0x00,        // 0x8D
	0x00,0x70,0x29,0x24,0x29,0x70,        // 0x8E
	0x00,0x78,0x2F,0x25,0x2F,0x78,        // 0x8F
	0x00,0x7C,0x54,0x54,0x55,0x45,        // 0x90
	0x00,0x34,0x54,0x7C,0x54,0x58,        // 0x91
	0x00,0x7E,0x09,0x7F,0x49,0x49,        // 0x92
	0x00,0x38,0x45,0x45,0x39,0x00,        // 0x93
	0x00,0x38,0x45,0x44,0x39,0x00,        // 0x94
	0x00,0x39,0x45,0x44,0x38,0x00,        // 0x95
	0x00,0x3C,0x41,0x21,0x7D,0x00,        // 0x96
	0x00,0x3D,0x41,0x20,0x7C,0x00,        // 0x97
	0x00,0x9C,0xA1,0x60,0x3D,0x00,        // 0x98
	0x00,0x3D,0x42,0x42,0x3D,0x00,        // 0x99
	0x00,0x3C,0x41,0x40,0x3D,0x00,        // 0x9A
	0x80,0x70,0x68,0x58,0x38,0x04,        // 0x9B
	0x00,0x48,0x3E,0x49,0x49,0x62,        // 0x9C
	0x00,0x7E,0x61,0x5D,0x43,0x3F,        // 0x9D
	0x00,0x22,0x14,0x08,0x14,0x22,        // 0x9E
	0x00,0x40,0x88,0x7E,0x09,0x02,        // 0x9F
	0x00,0x20,0x54,0x55,0x55,0x78,        // 0xA0
	0x00,0x00,0x00,0x7D,0x41,0x00,        // 0xA1
	0x00,0x38,0x44,0x45,0x39,0x00,        // 0xA2
	0x00,0x3C,0x40,0x21,0x7D,0x00,        // 0xA3
	0x00,0x7A,0x09,0x0A,0x71,0x00,        // 0xA4
	0x00,0x7A,0x11,0x22,0x79,0x00,        // 0xA5
	0x00,0x08,0x55,0x55,0x55,0x5E,        // 0xA6
	0x00,0x4E,0x51,0x51,0x4E,0x00,        // 0xA7
	0x00,0x30,0x48,0x4D,0x40,0x20,        // 0xA8
	0x3E,0x41,0x5D,0x4B,0x55,0x3E,        // 0xA9
	0x04,0x04,0x04,0x04,0x04,0x1C,        // 0xAA
	0x00,0x17,0x08,0x4C,0x6A,0x50,        // 0xAB
	0x00,0x17,0x08,0x34,0x2A,0x78,        // 0xAC
	0x00,0x00,0x30,0x7D,0x30,0x00,        // 0xAD
	0x00,0x08,0x14,0x00,0x08,0x14,        // 0xAE
	0x00,0x14,0x08,0x00,0x14,0x08,        // 0xAF
	0x44,0x11,0x44,0x11,0x44,0x11,        // 0xB0
	0xAA,0x55,0xAA,0x55,0xAA,0x55,        // 0xB1
	0xBB,0xEE,0xBB,0xEE,0xBB,0xEE,        // 0xB2
	0x00,0x00,0x00,0xFF,0x00,0x00,        // 0xB3
	0x08,0x08,0x08,0xFF,0x00,0x00,        // 0xB4
	0x00,0x70,0x28,0x25,0x29,0x70,        // 0xB5
	0x00,0x70,0x29,0x25,0x29,0x70,        // 0xB6
	0x00,0x70,0x29,0x25,0x28,0x70,        // 0xB7
	0x3E,0x41,0x5D,0x55,0x41,0x3E,        // 0xB8
	0x0A,0xFB,0x00,0xFF,0x00,0x00,        // 0xB9
	0x00,0xFF,0x00,0xFF,0x00,0x00,        // 0xBA
	0x0A,0xFA,0x02,0xFE,0x00,0x00,        // 0xBB
	0x0A,0x0B,0x08,0x0F,0x00,0x00,        // 0xBC
	0x00,0x18,0x24,0x66,0x24,0x00,        // 0xBD
	0x00,0x29,0x2A,0x7C,0x2A,0x29,        // 0xBE
	0x08,0x08,0x08,0xF8,0x00,0x00,        // 0xBF
	0x00,0x00,0x00,0x0F,0x08,0x08,        // 0xC0
	0x08,0x08,0x08,0x0F,0x08,0x08,        // 0xC1
	0x08,0x08,0x08,0xF8,0x08,0x08,        // 0xC2
	0x00,0x00,0x00,0xFF,0x08,0x08,        // 0xC3
	0x08,0x08,0x08,0x08,0x08,0x08,        // 0xC4
	0x08,0x08,0x08,0xFF,0x08,0x08,        // 0xC5
	0x00,0x20,0x56,0x55,0x56,0x79,        // 0xC6
	0x00,0x70,0x2A,0x25,0x2A,0x71,        // 0xC7
	0x00,0x0F,0x08,0x0B,0x0A,0x0A,        // 0xC8
	0x00,0xFE,0x02,0xFA,0x0A,0x0A,        // 0xC9
	0x0A,0x0B,0x08,0x0B,0x0A,0x0A,        // 0xCA
	0x0A,0xFA,0x02,0xFA,0x0A,0x0A,        // 0xCB
	0x00,0xFF,0x00,0xFB,0x0A,0x0A,        // 0xCC
	0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,        // 0xCD
	0x0A,0xFB,0x00,0xFB,0x0A,0x0A,        // 0xCE
	0x00,0x5D,0x22,0x22,0x22,0x5D,        // 0xCF
	0x00,0x22,0x55,0x59,0x30,0x00,        // 0xD0
	0x00,0x08,0x7F,0x49,0x41,0x3E,        // 0xD1
	0x00,0x7C,0x55,0x55,0x55,0x44,        // 0xD2
	0x00,0x7C,0x55,0x54,0x55,0x44,        // 0xD3
	0x00,0x7C,0x55,0x55,0x54,0x44,        // 0xD4
	0x00,0x00,0x00,0x07,0x00,0x00,        // 0xD5
	0x00,0x00,0x44,0x7D,0x45,0x00,        // 0xD6
	0x00,0x00,0x45,0x7D,0x45,0x00,        // 0xD7
	0x00,0x00,0x45,0x7C,0x45,0x00,        // 0xD8
	0x08,0x08,0x08,0x0F,0x00,0x00,        // 0xD9
	0x00,0x00,0x00,0xF8,0x08,0x08,        // 0xDA
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,        // 0xDB
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,        // 0xDC
	0x00,0x00,0x00,0x77,0x00,0x00,        // 0xDD
	0x00,0x00,0x45,0x7D,0x44,0x00,        // 0xDE
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,        // 0xDF
	0x00,0x3C,0x42,0x43,0x3D,0x00,        // 0xE0
	0x00,0xFE,0x4A,0x4A,0x34,0x00,        // 0xE1
	0x00,0x3C,0x43,0x43,0x3D,0x00,        // 0xE2
	0x00,0x3D,0x43,0x42,0x3C,0x00,        // 0xE3
	0x00,0x32,0x49,0x4A,0x31,0x00,        // 0xE4
	0x00,0x3A,0x45,0x46,0x39,0x00,        // 0xE5
	0x00,0xFC,0x20,0x20,0x1C,0x00,        // 0xE6
	0x00,0xFE,0xAA,0x28,0x10,0x00,        // 0xE7
	0x00,0xFF,0xA5,0x24,0x18,0x00,        // 0xE8
	0x00,0x3C,0x40,0x41,0x3D,0x00,        // 0xE9
	0x00,0x3C,0x41,0x41,0x3D,0x00,        // 0xEA
	0x00,0x3D,0x41,0x40,0x3C,0x00,        // 0xEB
	0x00,0x9C,0xA0,0x61,0x3D,0x00,        // 0xEC
	0x00,0x04,0x08,0x71,0x09,0x04,        // 0xED
	0x00,0x00,0x02,0x02,0x02,0x00,        // 0xEE
	0x00,0x00,0x07,0x03,0x00,0x00,        // 0xEF
	0x00,0x00,0x08,0x08,0x08,0x00,        // 0xF0
	0x00,0x00,0x24,0x2E,0x24,0x00,        // 0xF1
	0x00,0x24,0x24,0x24,0x24,0x24,        // 0xF2
	0x05,0x17,0x0A,0x34,0x2A,0x78,        // 0xF3
	0x00,0x06,0x09,0x7F,0x01,0x7F,        // 0xF4
	0x00,0x22,0x4D,0x55,0x59,0x22,        // 0xF5
	0x00,0x08,0x08,0x2A,0x08,0x08,        // 0xF6
	0x00,0x00,0x08,0x18,0x18,0x00,        // 0xF7
	0x00,0x06,0x09,0x09,0x06,0x00,        // 0xF8
	0x00,0x00,0x08,0x00,0x08,0x00,        // 0xF9
	0x00,0x00,0x08,0x00,0x00,0x00,        // 0xFA
	0x00,0x02,0x0F,0x00,0x00,0x00,        // 0xFB
	0x00,0x09,0x0F,0x05,0x00,0x00,        // 0xFC
	0x00,0x09,0x0D,0x0A,0x00,0x00,        // 0xFD
	0x00,0x3C,0x3C,0x3C,0x3C,0x00,        // 0xFE
	0x00,0x00,0x00,0x00,0x00,0x00         // 0xFF
};

unsigned char oled_font_12_16[] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x00
	0x00,0x00,0xF0,0x03,0x0C,0x0C,0x02,0x10,0x32,0x11,0x31,0x22,0x01,0x22,0x31,0x22,0x32,0x11,0x02,0x10,0x0C,0x0C,0xF0,0x03,      // 0x01
	0x00,0x00,0xF0,0x03,0xFC,0x0F,0xFE,0x1F,0xCE,0x1E,0xCF,0x3D,0xFF,0x3D,0xCF,0x3D,0xCE,0x1E,0xFE,0x1F,0xFC,0x0F,0xF0,0x03,      // 0x02
	0x00,0x00,0x00,0x00,0xF0,0x00,0xF8,0x01,0xF8,0x03,0xF0,0x07,0xE0,0x0F,0xF0,0x07,0xF8,0x03,0xF8,0x01,0xF0,0x00,0x00,0x00,      // 0x03
	0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x01,0xE0,0x03,0xF0,0x07,0xF8,0x0F,0xF0,0x07,0xE0,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,      // 0x04
	0x00,0x00,0x80,0x03,0xC0,0x07,0xC0,0x07,0xB8,0x13,0xFC,0x1B,0xFC,0x1F,0xFC,0x1B,0xB8,0x13,0xC0,0x07,0xC0,0x07,0x80,0x03,      // 0x05
	0x00,0x00,0x00,0x00,0x80,0x03,0xC0,0x07,0xE0,0x17,0xF0,0x1B,0xFC,0x1F,0xF0,0x1B,0xE0,0x17,0xC0,0x07,0x80,0x03,0x00,0x00,      // 0x06
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x07
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x08
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x09
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x0A
	0x00,0x00,0x80,0x03,0xC0,0x07,0x60,0x0C,0x20,0x08,0x20,0x08,0x60,0x0C,0xC8,0x07,0xA8,0x03,0x18,0x00,0x78,0x00,0x00,0x00,      // 0x0B
	0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0xF8,0x08,0x8C,0x09,0x04,0x3F,0x04,0x3F,0x8C,0x09,0xF8,0x08,0x70,0x00,0x00,0x00,      // 0x0C
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x0D
	0x00,0x00,0x00,0x06,0x00,0x0F,0x00,0x0F,0xFF,0x07,0x33,0x00,0x66,0x30,0xCC,0x78,0x98,0x79,0xF0,0x3F,0x00,0x00,0x00,0x00,      // 0x0E
	0x00,0x00,0x80,0x00,0xC8,0x09,0xF0,0x07,0x30,0x06,0x18,0x0C,0x1E,0x3C,0x18,0x0C,0x30,0x06,0xF0,0x07,0xC8,0x09,0x80,0x00,      // 0x0F
	0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x1F,0xF8,0x0F,0xF0,0x07,0xE0,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x10
	0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x01,0xE0,0x03,0xF0,0x07,0xF8,0x0F,0xFC,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x11
	0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x04,0x18,0x0C,0x1C,0x1C,0xFE,0x3F,0x1C,0x1C,0x18,0x0C,0x10,0x04,0x00,0x00,0x00,0x00,      // 0x12
	0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x37,0xFE,0x37,0x00,0x00,0x00,0x00,0xFE,0x37,0xFE,0x37,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x13
	0x00,0x00,0x38,0x00,0x7C,0x00,0xC6,0x00,0x82,0x00,0xFE,0x3F,0xFE,0x3F,0x02,0x00,0xFE,0x3F,0xFE,0x3F,0x02,0x00,0x00,0x00,      // 0x14
	0x00,0x00,0x00,0x00,0xDC,0x08,0xFE,0x19,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0xE6,0x1F,0xC4,0x0E,0x00,0x00,0x00,0x00,      // 0x15
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,      // 0x16
	0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x44,0x0C,0x4C,0x0E,0x5C,0xFF,0x7F,0x0E,0x5C,0x0C,0x4C,0x08,0x44,0x00,0x00,0x00,0x00,      // 0x17
	0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x18,0x00,0x1C,0x00,0xFE,0x3F,0x1C,0x00,0x18,0x00,0x10,0x00,0x00,0x00,0x00,0x00,      // 0x18
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x0C,0x00,0x1C,0xFE,0x3F,0x00,0x1C,0x00,0x0C,0x00,0x04,0x00,0x00,0x00,0x00,      // 0x19
	0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xF0,0x07,0xE0,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,      // 0x1A
	0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x01,0xE0,0x03,0xF0,0x07,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00,0x00,      // 0x1B
	0x00,0x00,0x00,0x3F,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x00,      // 0x1C
	0x00,0x00,0x80,0x00,0xC0,0x01,0xE0,0x03,0xF0,0x07,0x80,0x00,0x80,0x00,0x80,0x00,0xF0,0x07,0xE0,0x03,0xC0,0x01,0x80,0x00,      // 0x1D
	0x00,0x00,0x00,0x04,0x00,0x06,0x00,0x07,0x80,0x07,0xC0,0x07,0xE0,0x07,0xC0,0x07,0x80,0x07,0x00,0x07,0x00,0x06,0x00,0x04,      // 0x1E
	0x00,0x00,0x20,0x00,0x60,0x00,0xE0,0x00,0xE0,0x01,0xE0,0x03,0xE0,0x07,0xE0,0x03,0xE0,0x01,0xE0,0x00,0x60,0x00,0x20,0x00,      // 0x1F
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x20
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0xFF,0x33,0xFF,0x33,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x21
	0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x3C,0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x22
	0x00,0x00,0x00,0x02,0x10,0x1E,0x90,0x1F,0xF0,0x03,0x7E,0x02,0x1E,0x1E,0x90,0x1F,0xF0,0x03,0x7E,0x02,0x1E,0x00,0x10,0x00,      // 0x23
	0x00,0x00,0x00,0x00,0x78,0x04,0xFC,0x0C,0xCC,0x0C,0xFF,0x3F,0xFF,0x3F,0xCC,0x0C,0xCC,0x0F,0x88,0x07,0x00,0x00,0x00,0x00,      // 0x24
	0x00,0x00,0x00,0x30,0x38,0x38,0x38,0x1C,0x38,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x38,0x70,0x38,0x38,0x38,0x1C,0x00,      // 0x25
	0x00,0x00,0x00,0x00,0x00,0x1F,0xB8,0x3F,0xFC,0x31,0xC6,0x21,0xE2,0x37,0x3E,0x1E,0x1C,0x1C,0x00,0x36,0x00,0x22,0x00,0x00,      // 0x26
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x3F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x27
	0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xFC,0x0F,0xFE,0x1F,0x07,0x38,0x01,0x20,0x01,0x20,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x28
	0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x01,0x20,0x07,0x38,0xFE,0x1F,0xFC,0x0F,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x29
	0x00,0x00,0x00,0x00,0x98,0x0C,0xB8,0x0E,0xE0,0x03,0xF8,0x0F,0xF8,0x0F,0xE0,0x03,0xB8,0x0E,0x98,0x0C,0x00,0x00,0x00,0x00,      // 0x2A
	0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0xF0,0x0F,0xF0,0x0F,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,      // 0x2B
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB8,0x00,0xF8,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x2C
	0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,      // 0x2D
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x38,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x2E
	0x00,0x00,0x00,0x18,0x00,0x1C,0x00,0x0E,0x00,0x07,0x80,0x03,0xC0,0x01,0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,      // 0x2F
	0x00,0x00,0xF8,0x07,0xFE,0x1F,0x06,0x1E,0x03,0x33,0x83,0x31,0xC3,0x30,0x63,0x30,0x33,0x30,0x1E,0x18,0xFE,0x1F,0xF8,0x07,      // 0x30
	0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x30,0x0C,0x30,0x0E,0x30,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,      // 0x31
	0x00,0x00,0x1C,0x30,0x1E,0x38,0x07,0x3C,0x03,0x3E,0x03,0x37,0x83,0x33,0xC3,0x31,0xE3,0x30,0x77,0x30,0x3E,0x30,0x1C,0x30,      // 0x32
	0x00,0x00,0x0C,0x0C,0x0E,0x1C,0x07,0x38,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xE7,0x39,0x7E,0x1F,0x3C,0x0E,      // 0x33
	0x00,0x00,0xC0,0x03,0xE0,0x03,0x70,0x03,0x38,0x03,0x1C,0x03,0x0E,0x03,0x07,0x03,0xFF,0x3F,0xFF,0x3F,0x00,0x03,0x00,0x03,      // 0x34
	0x00,0x00,0x3F,0x0C,0x7F,0x1C,0x63,0x38,0x63,0x30,0x63,0x30,0x63,0x30,0x63,0x30,0x63,0x30,0xE3,0x38,0xC3,0x1F,0x83,0x0F,      // 0x35
	0x00,0x00,0xC0,0x0F,0xF0,0x1F,0xF8,0x39,0xDC,0x30,0xCE,0x30,0xC7,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x39,0x80,0x1F,0x00,0x0F,      // 0x36
	0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x30,0x03,0x3C,0x03,0x0F,0xC3,0x03,0xF3,0x00,0x3F,0x00,0x0F,0x00,0x03,0x00,      // 0x37
	0x00,0x00,0x00,0x0F,0xBC,0x1F,0xFE,0x39,0xE7,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xE7,0x30,0xFE,0x39,0xBC,0x1F,0x00,0x0F,      // 0x38
	0x00,0x00,0x3C,0x00,0x7E,0x00,0xE7,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x38,0xC3,0x1C,0xC3,0x0E,0xE7,0x07,0xFE,0x03,0xFC,0x00,      // 0x39
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x1C,0x70,0x1C,0x70,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x3A
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x9C,0x70,0xFC,0x70,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x3B
	0x00,0x00,0x00,0x00,0xC0,0x00,0xE0,0x01,0xF0,0x03,0x38,0x07,0x1C,0x0E,0x0E,0x1C,0x07,0x38,0x03,0x30,0x00,0x00,0x00,0x00,      // 0x3C
	0x00,0x00,0x00,0x00,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x60,0x06,0x00,0x00,      // 0x3D
	0x00,0x00,0x00,0x00,0x03,0x30,0x07,0x38,0x0E,0x1C,0x1C,0x0E,0x38,0x07,0xF0,0x03,0xE0,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,      // 0x3E
	0x00,0x00,0x1C,0x00,0x1E,0x00,0x07,0x00,0x03,0x00,0x83,0x37,0xC3,0x37,0xE3,0x00,0x77,0x00,0x3E,0x00,0x1C,0x00,0x00,0x00,      // 0x3F
	0x00,0x00,0xF8,0x0F,0xFE,0x1F,0x07,0x18,0xF3,0x33,0xFB,0x37,0x1B,0x36,0xFB,0x37,0xFB,0x37,0x07,0x36,0xFE,0x03,0xF8,0x01,      // 0x40
	0x00,0x00,0x00,0x38,0x00,0x3F,0xE0,0x07,0xFC,0x06,0x1F,0x06,0x1F,0x06,0xFC,0x06,0xE0,0x07,0x00,0x3F,0x00,0x38,0x00,0x00,      // 0x41
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xE7,0x30,0xFE,0x39,0xBC,0x1F,0x00,0x0F,0x00,0x00,      // 0x42
	0x00,0x00,0xF0,0x03,0xFC,0x0F,0x0E,0x1C,0x07,0x38,0x03,0x30,0x03,0x30,0x03,0x30,0x07,0x38,0x0E,0x1C,0x0C,0x0C,0x00,0x00,      // 0x43
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x03,0x30,0x03,0x30,0x03,0x30,0x03,0x30,0x07,0x38,0x0E,0x1C,0xFC,0x0F,0xF0,0x03,0x00,0x00,      // 0x44
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0x03,0x30,0x03,0x30,0x00,0x00,      // 0x45
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0xC3,0x00,0x03,0x00,0x03,0x00,0x00,0x00,      // 0x46
	0x00,0x00,0xF0,0x03,0xFC,0x0F,0x0E,0x1C,0x07,0x38,0x03,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC7,0x3F,0xC6,0x3F,0x00,0x00,      // 0x47
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x00,      // 0x48
	0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x30,0x03,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x30,0x03,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x49
	0x00,0x00,0x00,0x0E,0x00,0x1E,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x38,0xFF,0x1F,0xFF,0x07,0x00,0x00,      // 0x4A
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC0,0x00,0xE0,0x01,0xF0,0x03,0x38,0x07,0x1C,0x0E,0x0E,0x1C,0x07,0x38,0x03,0x30,0x00,0x00,      // 0x4B
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x00,      // 0x4C
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x1E,0x00,0x78,0x00,0xE0,0x01,0xE0,0x01,0x78,0x00,0x1E,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x00,      // 0x4D
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x0E,0x00,0x38,0x00,0xF0,0x00,0xC0,0x03,0x00,0x07,0x00,0x1C,0xFF,0x3F,0xFF,0x3F,0x00,0x00,      // 0x4E
	0x00,0x00,0xF0,0x03,0xFC,0x0F,0x0E,0x1C,0x07,0x38,0x03,0x30,0x03,0x30,0x07,0x38,0x0E,0x1C,0xFC,0x0F,0xF0,0x03,0x00,0x00,      // 0x4F
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x83,0x01,0x83,0x01,0x83,0x01,0x83,0x01,0x83,0x01,0xC7,0x01,0xFE,0x00,0x7C,0x00,0x00,0x00,      // 0x50
	0x00,0x00,0xF0,0x03,0xFC,0x0F,0x0E,0x1C,0x07,0x38,0x03,0x30,0x03,0x36,0x07,0x3E,0x0E,0x1C,0xFC,0x3F,0xF0,0x33,0x00,0x00,      // 0x51
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x83,0x01,0x83,0x01,0x83,0x03,0x83,0x07,0x83,0x0F,0xC7,0x1D,0xFE,0x38,0x7C,0x30,0x00,0x00,      // 0x52
	0x00,0x00,0x3C,0x0C,0x7E,0x1C,0xE7,0x38,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC3,0x30,0xC7,0x39,0x8E,0x1F,0x0C,0x0F,0x00,0x00,      // 0x53
	0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,      // 0x54
	0x00,0x00,0xFF,0x07,0xFF,0x1F,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x38,0xFF,0x1F,0xFF,0x07,0x00,0x00,      // 0x55
	0x00,0x00,0x07,0x00,0x3F,0x00,0xF8,0x01,0xC0,0x0F,0x00,0x3E,0x00,0x3E,0xC0,0x0F,0xF8,0x01,0x3F,0x00,0x07,0x00,0x00,0x00,      // 0x56
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x1C,0x00,0x06,0x80,0x03,0x80,0x03,0x00,0x06,0x00,0x1C,0xFF,0x3F,0xFF,0x3F,0x00,0x00,      // 0x57
	0x00,0x00,0x03,0x30,0x0F,0x3C,0x1C,0x0E,0x30,0x03,0xE0,0x01,0xE0,0x01,0x30,0x03,0x1C,0x0E,0x0F,0x3C,0x03,0x30,0x00,0x00,      // 0x58
	0x00,0x00,0x03,0x00,0x0F,0x00,0x3C,0x00,0xF0,0x00,0xC0,0x3F,0xC0,0x3F,0xF0,0x00,0x3C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,      // 0x59
	0x00,0x00,0x03,0x30,0x03,0x3C,0x03,0x3E,0x03,0x33,0xC3,0x31,0xE3,0x30,0x33,0x30,0x1F,0x30,0x0F,0x30,0x03,0x30,0x00,0x00,      // 0x5A
	0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x03,0x30,0x03,0x30,0x03,0x30,0x03,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x5B
	0x00,0x00,0x0E,0x00,0x1C,0x00,0x38,0x00,0x70,0x00,0xE0,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x1C,0x00,0x18,      // 0x5C
	0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x30,0x03,0x30,0x03,0x30,0x03,0x30,0xFF,0x3F,0xFF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x5D
	0x00,0x00,0x60,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x0E,0x00,0x1C,0x00,0x38,0x00,0x70,0x00,0x60,0x00,      // 0x5E
	0x00,0x00,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,      // 0x5F
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x00,0x7E,0x00,0x4E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x60
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0xE0,0x3F,0xC0,0x3F,0x00,0x00,      // 0x61
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC0,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0xE0,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0x62
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x38,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0xC0,0x18,0x80,0x08,0x00,0x00,      // 0x63
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x38,0x60,0x30,0x60,0x30,0x60,0x30,0xE0,0x30,0xC0,0x30,0xFF,0x3F,0xFF,0x3F,0x00,0x00,      // 0x64
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x3B,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0xC0,0x13,0x80,0x01,0x00,0x00,      // 0x65
	0x00,0x00,0xC0,0x00,0xC0,0x00,0xFC,0x3F,0xFE,0x3F,0xC7,0x00,0xC3,0x00,0xC3,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x66
	0x00,0x00,0x80,0x03,0xC0,0xC7,0xE0,0xCE,0x60,0xCC,0x60,0xCC,0x60,0xCC,0x60,0xCC,0x60,0xE6,0xE0,0x7F,0xE0,0x3F,0x00,0x00,      // 0x67
	0x00,0x00,0xFF,0x3F,0xFF,0x3F,0xC0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x00,0xC0,0x3F,0x80,0x3F,0x00,0x00,0x00,0x00,      // 0x68
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x60,0x30,0xEC,0x3F,0xEC,0x3F,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x69
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xE0,0x00,0xC0,0x60,0xC0,0xEC,0xFF,0xEC,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x6A
	0x00,0x00,0x00,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x03,0x80,0x07,0xC0,0x0F,0xE0,0x1C,0x60,0x38,0x00,0x30,0x00,0x00,0x00,0x00,      // 0x6B
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x03,0x30,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x6C
	0x00,0x00,0xE0,0x3F,0xC0,0x3F,0xE0,0x00,0xE0,0x00,0xC0,0x3F,0xC0,0x3F,0xE0,0x00,0xE0,0x00,0xC0,0x3F,0x80,0x3F,0x00,0x00,      // 0x6D
	0x00,0x00,0x00,0x00,0xE0,0x3F,0xE0,0x3F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x00,0xC0,0x3F,0x80,0x3F,0x00,0x00,      // 0x6E
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x38,0x60,0x30,0x60,0x30,0x60,0x30,0x60,0x30,0xE0,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0x6F
	0x00,0x00,0xE0,0xFF,0xE0,0xFF,0x60,0x0C,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0xE0,0x1C,0xC0,0x0F,0x80,0x07,0x00,0x00,      // 0x70
	0x00,0x00,0x80,0x07,0xC0,0x0F,0xE0,0x1C,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x18,0x60,0x0C,0xE0,0xFF,0xE0,0xFF,0x00,0x00,      // 0x71
	0x00,0x00,0x00,0x00,0xE0,0x3F,0xE0,0x3F,0xC0,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0xE0,0x00,0xC0,0x00,0x00,0x00,      // 0x72
	0x00,0x00,0xC0,0x11,0xE0,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x33,0x60,0x3F,0x40,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x73
	0x00,0x00,0x60,0x00,0x60,0x00,0xFE,0x1F,0xFE,0x3F,0x60,0x30,0x60,0x30,0x60,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x74
	0x00,0x00,0xE0,0x0F,0xE0,0x1F,0x00,0x38,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x30,0x00,0x18,0xE0,0x3F,0xE0,0x3F,0x00,0x00,      // 0x75
	0x00,0x00,0x60,0x00,0xE0,0x01,0x80,0x07,0x00,0x1E,0x00,0x38,0x00,0x38,0x00,0x1E,0x80,0x07,0xE0,0x01,0x60,0x00,0x00,0x00,      // 0x76
	0x00,0x00,0xE0,0x07,0xE0,0x1F,0x00,0x38,0x00,0x1C,0xE0,0x0F,0xE0,0x0F,0x00,0x1C,0x00,0x38,0xE0,0x1F,0xE0,0x07,0x00,0x00,      // 0x77
	0x00,0x00,0x60,0x30,0xE0,0x38,0xC0,0x1D,0x80,0x0F,0x00,0x07,0x80,0x0F,0xC0,0x1D,0xE0,0x38,0x60,0x30,0x00,0x00,0x00,0x00,      // 0x78
	0x00,0x00,0x00,0x00,0x60,0x00,0xE0,0x81,0x80,0xE7,0x00,0x7E,0x00,0x1E,0x80,0x07,0xE0,0x01,0x60,0x00,0x00,0x00,0x00,0x00,      // 0x79
	0x00,0x00,0x60,0x30,0x60,0x38,0x60,0x3C,0x60,0x36,0x60,0x33,0xE0,0x31,0xE0,0x30,0x60,0x30,0x20,0x30,0x00,0x00,0x00,0x00,      // 0x7A
	0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x01,0xFC,0x1F,0x7E,0x3F,0x07,0x70,0x03,0x60,0x03,0x60,0x03,0x60,0x00,0x00,0x00,0x00,      // 0x7B
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xBF,0x3F,0xBF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x7C
	0x00,0x00,0x00,0x00,0x03,0x60,0x03,0x60,0x03,0x60,0x07,0x70,0x7E,0x3F,0xFC,0x1F,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x00,      // 0x7D
	0x00,0x00,0x10,0x00,0x18,0x00,0x0C,0x00,0x04,0x00,0x0C,0x00,0x18,0x00,0x10,0x00,0x18,0x00,0x0C,0x00,0x04,0x00,0x00,0x00,      // 0x7E
	0x00,0x00,0x00,0x0F,0x80,0x0F,0xC0,0x0C,0x60,0x0C,0x30,0x0C,0x30,0x0C,0x60,0x0C,0xC0,0x0C,0x80,0x0F,0x00,0x0F,0x00,0x00,      // 0x7F
	0x00,0x00,0xF0,0x01,0xFC,0x07,0x0E,0xCE,0x07,0xDC,0x03,0xF8,0x03,0xF8,0x03,0x18,0x07,0x1C,0x1E,0x0E,0x1C,0x06,0x00,0x00,      // 0x80
	0x00,0x00,0xE0,0x0F,0xE0,0x1F,0x0C,0x38,0x0C,0x30,0x00,0x30,0x00,0x30,0x0C,0x30,0x0C,0x18,0xE0,0x3F,0xE0,0x3F,0x00,0x00,      // 0x81
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x3B,0x60,0x33,0x68,0x33,0x6C,0x33,0x66,0x33,0x62,0x33,0xC0,0x13,0x80,0x03,0x00,0x00,      // 0x82
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x68,0x33,0x6C,0x33,0x66,0x33,0x66,0x33,0x6C,0x33,0x68,0x33,0xE0,0x3F,0xC0,0x3F,0x00,0x00,      // 0x83
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x6C,0x33,0x6C,0x33,0x60,0x33,0x60,0x33,0x6C,0x33,0x6C,0x33,0xE0,0x3F,0xC0,0x3F,0x00,0x00,      // 0x84
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x60,0x33,0x62,0x33,0x66,0x33,0x6C,0x33,0x68,0x33,0x60,0x33,0xE0,0x3F,0xC0,0x3F,0x00,0x00,      // 0x85
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x60,0x33,0x64,0x33,0x6A,0x33,0x6A,0x33,0x64,0x33,0x60,0x33,0xE0,0x3F,0xC0,0x3F,0x00,0x00,      // 0x86
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0xB8,0x60,0xB0,0x60,0xF0,0x60,0xF0,0x60,0x30,0xE0,0x38,0xC0,0x18,0x80,0x08,0x00,0x00,      // 0x87
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE8,0x33,0x6C,0x33,0x66,0x33,0x66,0x33,0x6C,0x33,0x68,0x33,0xC0,0x13,0x80,0x03,0x00,0x00,      // 0x88
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xEC,0x33,0x6C,0x33,0x60,0x33,0x60,0x33,0x6C,0x33,0x6C,0x33,0xC0,0x13,0x80,0x03,0x00,0x00,      // 0x89
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x33,0x62,0x33,0x66,0x33,0x6C,0x33,0x68,0x33,0x60,0x33,0xC0,0x13,0x80,0x03,0x00,0x00,      // 0x8A
	0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x30,0x6C,0x30,0xE0,0x3F,0xEC,0x3F,0x0C,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x8B
	0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x30,0x6C,0x30,0xE6,0x3F,0xE6,0x3F,0x0C,0x30,0x08,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x8C
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x62,0x30,0xE6,0x3F,0xEC,0x3F,0x08,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0x8D
	0x00,0x00,0x00,0x38,0x00,0x3E,0x83,0x0F,0xE3,0x0D,0x78,0x0C,0x78,0x0C,0xE3,0x0D,0x83,0x0F,0x00,0x3E,0x00,0x38,0x00,0x00,      // 0x8E
	0x00,0x00,0x00,0x38,0x00,0x3E,0x80,0x0F,0xE2,0x0D,0x75,0x0C,0x75,0x0C,0xE2,0x0D,0x80,0x0F,0x00,0x3E,0x00,0x38,0x00,0x00,      // 0x8F
	0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x98,0x31,0x98,0x31,0x9C,0x31,0x9E,0x31,0x9B,0x31,0x99,0x31,0x18,0x30,0x18,0x30,0x00,0x00,      // 0x90
	0x00,0x00,0x80,0x1C,0xC0,0x3E,0x40,0x22,0x40,0x22,0xC0,0x1F,0x80,0x3F,0x40,0x22,0x40,0x22,0xC0,0x33,0x80,0x11,0x00,0x00,      // 0x91
	0x00,0x00,0x00,0x3C,0x80,0x3F,0xF0,0x07,0x7C,0x06,0x1F,0x06,0xFF,0x3F,0xFF,0x3F,0xC3,0x30,0xC3,0x30,0x03,0x30,0x00,0x00,      // 0x92
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE8,0x38,0x6C,0x30,0x66,0x30,0x66,0x30,0x6C,0x30,0xE8,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0x93
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xEC,0x38,0x6C,0x30,0x60,0x30,0x60,0x30,0x6C,0x30,0xEC,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0x94
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x38,0x62,0x30,0x66,0x30,0x6C,0x30,0x68,0x30,0xE0,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0x95
	0x00,0x00,0xE0,0x0F,0xE0,0x1F,0x08,0x38,0x0C,0x30,0x06,0x30,0x06,0x30,0x0C,0x30,0x08,0x18,0xE0,0x3F,0xE0,0x3F,0x00,0x00,      // 0x96
	0x00,0x00,0xE0,0x0F,0xE0,0x1F,0x00,0x38,0x02,0x30,0x06,0x30,0x0C,0x30,0x08,0x30,0x00,0x18,0xE0,0x3F,0xE0,0x3F,0x00,0x00,      // 0x97
	0x00,0x00,0x00,0x00,0x60,0x00,0xEC,0x81,0x8C,0xE7,0x00,0x7E,0x00,0x1E,0x8C,0x07,0xEC,0x01,0x60,0x00,0x00,0x00,0x00,0x00,      // 0x98
	0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x3B,0x38,0x1B,0x30,0x18,0x30,0x18,0x30,0x1B,0x30,0x3B,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,      // 0x99
	0x00,0x00,0xE0,0x0F,0xE0,0x1F,0x0C,0x38,0x0C,0x30,0x00,0x30,0x00,0x30,0x0C,0x30,0x0C,0x18,0xE0,0x3F,0xE0,0x3F,0x00,0x00,      // 0x9A
	0x00,0x00,0x80,0x2F,0xC0,0x3F,0xE0,0x18,0x60,0x3C,0x60,0x36,0x60,0x33,0xE0,0x31,0xC0,0x38,0xE0,0x1F,0xA0,0x0F,0x00,0x00,      // 0x9B
	0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x1C,0xF8,0x1F,0xFC,0x0B,0x8C,0x18,0x8C,0x18,0x1C,0x18,0x18,0x18,0x00,0x08,0x00,0x00,      // 0x9C
	0x00,0x00,0xF0,0x2F,0xF8,0x3F,0x1C,0x18,0x0C,0x3E,0x8C,0x37,0xEC,0x31,0x7C,0x30,0x18,0x38,0xFC,0x1F,0xF4,0x0F,0x00,0x00,      // 0x9D
	0x00,0x00,0x00,0x00,0x10,0x04,0x30,0x06,0x60,0x03,0xC0,0x01,0xC0,0x01,0x60,0x03,0x30,0x06,0x10,0x04,0x00,0x00,0x00,0x00,      // 0x9E
	0x00,0x00,0x00,0x00,0x00,0x30,0x80,0x70,0x80,0x60,0xFE,0x7F,0xFF,0x3F,0x83,0x00,0x87,0x00,0x06,0x00,0x00,0x00,0x00,0x00,      // 0x9F
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x60,0x33,0x68,0x33,0x6C,0x33,0x66,0x33,0x62,0x33,0x60,0x33,0xE0,0x3F,0xC0,0x3F,0x00,0x00,      // 0xA0
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x68,0x30,0xEC,0x3F,0xE6,0x3F,0x02,0x30,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xA1
	0x00,0x00,0x80,0x0F,0xC0,0x1F,0xE0,0x38,0x68,0x30,0x6C,0x30,0x66,0x30,0x62,0x30,0xE0,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0xA2
	0x00,0x00,0xE0,0x0F,0xE0,0x1F,0x00,0x38,0x08,0x30,0x0C,0x30,0x06,0x30,0x02,0x30,0x00,0x18,0xE0,0x3F,0xE0,0x3F,0x00,0x00,      // 0xA3
	0x00,0x00,0x00,0x00,0xE0,0x3F,0xE8,0x3F,0x6C,0x00,0x64,0x00,0x6C,0x00,0x68,0x00,0xEC,0x00,0xC4,0x3F,0x80,0x3F,0x00,0x00,      // 0xA4
	0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x72,0x00,0xE3,0x00,0xC1,0x01,0x83,0x03,0x02,0x07,0x03,0x0E,0xF9,0x3F,0xF8,0x3F,0x00,0x00,      // 0xA5
	0x00,0x00,0x70,0x00,0xFA,0x06,0xDB,0x06,0xDB,0x06,0xDB,0x06,0xDB,0x06,0xDB,0x06,0xDB,0x06,0xFF,0x06,0xFE,0x00,0x00,0x00,      // 0xA6
	0x00,0x00,0x3C,0x00,0x7E,0x06,0xE7,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xC3,0x06,0xE7,0x06,0x7E,0x06,0x3C,0x00,0x00,0x00,      // 0xA7
	0x00,0x00,0x00,0x0E,0x00,0x1F,0x80,0x3B,0xC0,0x31,0xFB,0x30,0x7B,0x30,0x00,0x30,0x00,0x38,0x00,0x1E,0x00,0x0E,0x00,0x00,      // 0xA8
	0x00,0x00,0xF0,0x07,0xF8,0x0F,0x1C,0x1C,0xEC,0x1B,0xEC,0x1B,0xAC,0x18,0xEC,0x1B,0x4C,0x1B,0x1C,0x1C,0xF8,0x0F,0xF0,0x07,      // 0xA9
	0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x03,0xF8,0x03,0x00,0x00,      // 0xAA
	0x00,0x00,0x48,0x00,0x7C,0x04,0x7C,0x06,0x40,0x03,0x80,0x01,0xC0,0x00,0x60,0x19,0x30,0x1D,0x10,0x17,0x00,0x12,0x00,0x00,      // 0xAB
	0x00,0x00,0x48,0x00,0x7C,0x04,0x7C,0x06,0x40,0x03,0x80,0x01,0xC0,0x06,0x60,0x07,0x30,0x04,0x10,0x1F,0x00,0x1F,0x00,0x00,      // 0xAC
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0F,0xF3,0x3F,0xF3,0x3F,0x80,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xAD
	0x00,0x00,0x80,0x00,0xC0,0x01,0x60,0x03,0x20,0x02,0x00,0x00,0x80,0x00,0xC0,0x01,0x60,0x03,0x20,0x02,0x00,0x00,0x00,0x00,      // 0xAE
	0x00,0x00,0x20,0x02,0x60,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,0x20,0x02,0x60,0x03,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x00,      // 0xAF
	0x55,0x55,0x00,0x00,0xAA,0xAA,0x00,0x00,0x55,0x55,0x00,0x00,0xAA,0xAA,0x00,0x00,0x55,0x55,0x00,0x00,0xAA,0xAA,0x00,0x00,      // 0xB0
	0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,0xAA,0xAA,0x55,0x55,      // 0xB1
	0xAA,0xAA,0xFF,0xFF,0x55,0x55,0xFF,0xFF,0xAA,0xAA,0xFF,0xFF,0x55,0x55,0xFF,0xFF,0xAA,0xAA,0xFF,0xFF,0x55,0x55,0xFF,0xFF,      // 0xB2
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xB3
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xB4
	0x00,0x00,0x00,0x38,0x00,0x3E,0x80,0x0F,0xE4,0x0D,0x7E,0x0C,0x7B,0x0C,0xE1,0x0D,0x80,0x0F,0x00,0x3E,0x00,0x38,0x00,0x00,      // 0xB5
	0x00,0x00,0x00,0x38,0x00,0x3E,0x84,0x0F,0xE6,0x0D,0x7B,0x0C,0x7B,0x0C,0xE6,0x0D,0x84,0x0F,0x00,0x3E,0x00,0x38,0x00,0x00,      // 0xB6
	0x00,0x00,0x00,0x38,0x00,0x3E,0x80,0x0F,0xE1,0x0D,0x7B,0x0C,0x7E,0x0C,0xE4,0x0D,0x80,0x0F,0x00,0x3E,0x00,0x38,0x00,0x00,      // 0xB7
	0x00,0x00,0xF0,0x07,0xF8,0x0F,0x1C,0x1C,0xCC,0x19,0xEC,0x1B,0x2C,0x1A,0x6C,0x1B,0x4C,0x19,0x1C,0x1C,0xF8,0x0F,0xF0,0x07,      // 0xB8
	0xC0,0x06,0xC0,0x06,0xFF,0xFE,0xFF,0xFE,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xB9
	0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xBA
	0xC0,0x06,0xC0,0x06,0xC0,0xFE,0xC0,0xFE,0xC0,0x00,0xC0,0xFF,0xC0,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xBB
	0xC0,0x06,0xC0,0x06,0xFF,0x06,0xFF,0x06,0x00,0x06,0xFF,0x07,0xFF,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xBC
	0x00,0x00,0x00,0x00,0xE0,0x03,0xF0,0x07,0x38,0x0E,0xFE,0x3F,0xFE,0x3F,0x18,0x0C,0x38,0x0E,0x30,0x06,0x00,0x00,0x00,0x00,      // 0xBD
	0x00,0x00,0x03,0x00,0x0F,0x0A,0x3C,0x0A,0xF0,0x0A,0xC0,0x3F,0xC0,0x3F,0xF0,0x0A,0x3C,0x0A,0x0F,0x0A,0x03,0x00,0x00,0x00,      // 0xBE
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xFF,0x80,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xBF
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x01,0xFF,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xC0
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0x01,0xFF,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xC1
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xFF,0x80,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xC2
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xC3
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xC4
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0xFF,0xFF,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xC5
	0x00,0x00,0x00,0x1C,0x40,0x3E,0x68,0x33,0x6C,0x33,0x64,0x33,0x6C,0x33,0x68,0x33,0x6C,0x33,0xE4,0x3F,0xC0,0x3F,0x00,0x00,      // 0xC6
	0x00,0x00,0x00,0x38,0x00,0x3E,0x82,0x0F,0xE3,0x0D,0x79,0x0C,0x7B,0x0C,0xE2,0x0D,0x83,0x0F,0x01,0x3E,0x00,0x38,0x00,0x00,      // 0xC7
	0x00,0x00,0x00,0x00,0xFF,0x07,0xFF,0x07,0x00,0x06,0xFF,0x06,0xFF,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xC8
	0x00,0x00,0x00,0x00,0xC0,0xFF,0xC0,0xFF,0xC0,0x00,0xC0,0xFE,0xC0,0xFE,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xC9
	0xC0,0x06,0xC0,0x06,0xFF,0x06,0xFF,0x06,0x00,0x06,0xFF,0x06,0xFF,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xCA
	0xC0,0x06,0xC0,0x06,0xC0,0xFE,0xC0,0xFE,0xC0,0x00,0xC0,0xFE,0xC0,0xFE,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xCB
	0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0xFE,0xFF,0xFE,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xCC
	0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xCD
	0xC0,0x06,0xC0,0x06,0xFF,0xFE,0xFF,0xFE,0x00,0x00,0xFF,0xFE,0xFF,0xFE,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,      // 0xCE
	0x00,0x00,0xF6,0x1B,0xFE,0x1F,0x18,0x06,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x06,0xFE,0x1F,0xF6,0x1B,0x00,0x00,      // 0xCF
	0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x1C,0xFC,0x3E,0xCC,0x33,0x8C,0x33,0x0C,0x3F,0x18,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xD0
	0x00,0x00,0xC0,0x00,0xFF,0x3F,0xFF,0x3F,0xC3,0x30,0x03,0x30,0x03,0x30,0x07,0x38,0x0E,0x1C,0xFC,0x0F,0xF0,0x03,0x00,0x00,      // 0xD1
	0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x9C,0x31,0x9E,0x31,0x9B,0x31,0x9B,0x31,0x9E,0x31,0x9C,0x31,0x18,0x30,0x18,0x30,0x00,0x00,      // 0xD2
	0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x9B,0x31,0x9B,0x31,0x98,0x31,0x98,0x31,0x9B,0x31,0x9B,0x31,0x18,0x30,0x18,0x30,0x00,0x00,      // 0xD3
	0x00,0x00,0xF8,0x3F,0xF8,0x3F,0x99,0x31,0x9B,0x31,0x9E,0x31,0x9C,0x31,0x98,0x31,0x98,0x31,0x18,0x30,0x18,0x30,0x00,0x00,      // 0xD4
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xD5
	0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x30,0x18,0x30,0xFC,0x3F,0xFE,0x3F,0x1B,0x30,0x19,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xD6
	0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x30,0x1E,0x30,0xFB,0x3F,0xFB,0x3F,0x1E,0x30,0x1C,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xD7
	0x00,0x00,0x00,0x00,0x00,0x00,0x1B,0x30,0x1B,0x30,0xF8,0x3F,0xF8,0x3F,0x1B,0x30,0x1B,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xD8
	0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xFF,0x01,0xFF,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xD9
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xFF,0x80,0xFF,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,      // 0xDA
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,      // 0xDB
	0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,      // 0xDC
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xBF,0x3F,0xBF,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xDD
	0x00,0x00,0x00,0x00,0x00,0x00,0x19,0x30,0x1B,0x30,0xFE,0x3F,0xFC,0x3F,0x18,0x30,0x18,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xDE
	0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,      // 0xDF
	0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x38,0x38,0x18,0x30,0x1C,0x30,0x1E,0x30,0x1B,0x30,0x39,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,      // 0xE0
	0x00,0x00,0x00,0x00,0xC0,0xFF,0xE0,0xFF,0x30,0x21,0x10,0x21,0x10,0x21,0x30,0x33,0xE0,0x3F,0xC0,0x1E,0x00,0x00,0x00,0x00,      // 0xE1
	0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x3C,0x38,0x1E,0x30,0x1B,0x30,0x1B,0x30,0x1E,0x30,0x3C,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,      // 0xE2
	0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x39,0x38,0x1B,0x30,0x1E,0x30,0x1C,0x30,0x18,0x30,0x38,0x38,0xF0,0x1F,0xE0,0x0F,0x00,0x00,      // 0xE3
	0x00,0x00,0x80,0x0F,0xC8,0x1F,0xEC,0x38,0x64,0x30,0x6C,0x30,0x68,0x30,0x6C,0x30,0xE4,0x38,0xC0,0x1F,0x80,0x0F,0x00,0x00,      // 0xE4
	0x00,0x00,0xE0,0x0F,0xF0,0x1F,0x3A,0x38,0x1B,0x30,0x19,0x30,0x1B,0x30,0x1A,0x30,0x3B,0x38,0xF1,0x1F,0xE0,0x0F,0x00,0x00,      // 0xE5
	0x00,0x00,0xF0,0xFF,0xF0,0xFF,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x06,0xF0,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x00,      // 0xE6
	0x00,0x00,0x00,0x00,0x0C,0x30,0xFC,0x3F,0xFC,0x3F,0x6C,0x36,0x60,0x06,0x60,0x06,0xE0,0x07,0xC0,0x03,0x00,0x00,0x00,0x00,      // 0xE7
	0x00,0x00,0x00,0x00,0x03,0x30,0xFF,0x3F,0xFF,0x3F,0x1B,0x36,0x18,0x06,0x18,0x06,0xF8,0x07,0xF0,0x03,0x00,0x00,0x00,0x00,      // 0xE8
	0x00,0x00,0xF8,0x07,0xF8,0x1F,0x00,0x38,0x00,0x30,0x04,0x30,0x06,0x30,0x03,0x30,0x01,0x38,0xF8,0x1F,0xF8,0x07,0x00,0x00,      // 0xE9
	0x00,0x00,0xF8,0x07,0xF8,0x1F,0x04,0x38,0x06,0x30,0x03,0x30,0x03,0x30,0x06,0x30,0x04,0x38,0xF8,0x1F,0xF8,0x07,0x00,0x00,      // 0xEA
	0x00,0x00,0xF8,0x07,0xF8,0x1F,0x01,0x38,0x03,0x30,0x06,0x30,0x04,0x30,0x00,0x30,0x00,0x38,0xF8,0x1F,0xF8,0x07,0x00,0x00,      // 0xEB
	0x00,0x00,0x00,0x00,0x60,0x00,0xE0,0x81,0x80,0xE7,0x10,0x7E,0x18,0x1E,0x8C,0x07,0xE4,0x01,0x60,0x00,0x00,0x00,0x00,0x00,      // 0xEC
	0x00,0x00,0x08,0x00,0x18,0x00,0x30,0x00,0x60,0x00,0xC4,0x3F,0xC6,0x3F,0x63,0x00,0x31,0x00,0x18,0x00,0x08,0x00,0x00,0x00,      // 0xED
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xEE
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x06,0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xEF
	0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xF0
	0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x18,0xC0,0x18,0xF0,0x1B,0xF0,0x1B,0xC0,0x18,0xC0,0x18,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xF1
	0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xF2
	0x00,0x00,0x44,0x00,0x54,0x04,0x7C,0x06,0x28,0x03,0x80,0x01,0xC0,0x06,0x60,0x07,0x30,0x04,0x10,0x1F,0x00,0x1F,0x00,0x00,      // 0xF3
	0x00,0x00,0x38,0x00,0x7C,0x00,0xC6,0x00,0x82,0x00,0xFE,0x3F,0xFE,0x3F,0x02,0x00,0xFE,0x3F,0xFE,0x3F,0x02,0x00,0x00,0x00,      // 0xF4
	0x00,0x00,0x00,0x00,0xDC,0x08,0xFE,0x19,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0xE6,0x1F,0xC4,0x0E,0x00,0x00,0x00,0x00,      // 0xF5
	0x00,0x00,0x00,0x00,0x80,0x01,0x80,0x01,0x80,0x01,0xB0,0x0D,0xB0,0x0D,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,      // 0xF6
	0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x80,0x00,0x80,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xF7
	0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,0x3F,0x00,0x33,0x00,0x33,0x00,0x3F,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xF8
	0x00,0x00,0x00,0x00,0x80,0x01,0xC0,0x03,0x80,0x01,0x00,0x00,0x00,0x00,0x80,0x01,0xC0,0x03,0x80,0x01,0x00,0x00,0x00,0x00,      // 0xF9
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0xC0,0x03,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xFA
	0x00,0x00,0x00,0x00,0x02,0x00,0x1F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xFB
	0x00,0x00,0x00,0x00,0x11,0x00,0x15,0x00,0x15,0x00,0x1F,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xFC
	0x00,0x00,0x00,0x00,0x19,0x00,0x1D,0x00,0x15,0x00,0x17,0x00,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xFD
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x03,0xF0,0x03,0xF0,0x03,0xF0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      // 0xFE
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00       // 0xFF
};

oled_i2c_init_t oled_i2c_init_array[] = {
	{ .command = OLED_REG_DISPLAY_OFF, .data = -1 },
	{ .command = OLED_REG_DISPLAY_CLOCKDIV, .data = 0x80 }, // 0xD5 + the suggested ratio 0x80
	{ .command = OLED_REG_MULTIPLEX, .data = 0x3f }, // 0xD3 + no offset
	{ .command = OLED_REG_DISPLAY_OFFSET, .data = 0x00 }, // line #0
	{ .command = OLED_REG_SETSTARTLINE, .data = 0x00 }, // line #0
	{ .command = OLED_REG_CHARGE_PUMP, .data = 0x14 },
	{ .command = OLED_REG_MEMORY_MODE, .data = 0x00 }, // 0x20 0x0 act like ks0108
	{ .command = OLED_REG_SEG_REMAP | 0x1, .data = -1 },
	{ .command = OLED_REG_COMSCAN_DEC, .data = -1 },
	{ .command = OLED_REG_COMPINS, .data = 0x12 },
	{ .command = OLED_REG_CONTRAST_LEVEL, .data = 0xdf }, // contrast level 0 to 0xff
	{ .command = OLED_REG_PRECHARGE, .data = 0xf1 },
	{ .command = OLED_REG_VCOM_DETECT, .data = 0x40 },
	{ .command = OLED_REG_DISPLAYALLON_RESUME, .data = -1 },
	{ .command = OLED_REG_NORMAL_DISPLAY, .data = -1 },
	{ .command = -1, .data = -1 }
};

OLED_SH1106::OLED_SH1106(void) {
	chipset = ocs_sh1106;
	channel = 0;
	address = 0x3c;
}

void OLED_SH1106::init(void) {
	flag = 0;
	set_flag = 0;
	clr_flag = 0;
	state = s_detect;
}

int OLED_SH1106::prop_count(void) {
	// not supported
	return 0;
}

bool OLED_SH1106::prop_name(int index, char *name) {
	// not supported
	return false;
}

bool OLED_SH1106::prop_unit(int index, char *unit) {
	// not supported
	return false;
}

bool OLED_SH1106::prop_attr(int index, char *attr) {
	// not supported
	return false;
}

bool OLED_SH1106::prop_read(int index, char *value) {
	// not supported
	return false;
}

bool OLED_SH1106::prop_write(int index, char *value) {
	// not supported
	return false;
}

void OLED_SH1106::clear(void) {
	// clear draw
	memset(vram, 0x00, (OLED_I2C_WIDTH * (OLED_I2C_HEIGHT / 8)));
	// set render flag
	set_flag |= (0x80 | OLED_I2C_RENDER_FLAG);
}

esp_err_t OLED_SH1106::render(I2CDev *i2c) {
	int page, i, j;
	unsigned char buf[17], *p;
	esp_err_t ret;

	switch (chipset) {
		case ocs_ssd1306:
			buf[0] = 0; // command
			buf[1] = OLED_REG_LOW_COLUMN | 0x0; // low col = 0 (ssd1306)
			if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
				return ret;
			}
			buf[1] = OLED_REG_HIGH_COLUMN | 0x0; // hi col = 0
			if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
				return ret;
			}
			buf[1] = OLED_REG_SETSTARTLINE | 0x0; // line #0
			if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
				return ret;
			}

			p = vram;

			for (i = 0; i < 64; i ++) {
				buf[0] = 0x40; // data
				for (j = 1; j < 17; j++) {
					buf[j] = *p++;
				}
				if ((ret = i2c->write(channel, address, buf, 17)) != ESP_OK) {
					return ret;
				}
			}
			break;

		case ocs_sh1106:
			// sh1106 => use 8 pages of 16*8 bytes for 1 lines
			for (page = 0; page < 8; page++) {
				buf[0] = 0; // command
				buf[1] = OLED_REG_LOW_COLUMN | 0x2; // low col = 2 (sh1106)
				if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
					return ret;
				}
				buf[1] = OLED_REG_HIGH_COLUMN | 0x0; // hi col = 0
				if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
					return ret;
				}
				buf[1] = OLED_REG_SETSTARTLINE | 0x0; // line #0
				if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
					return ret;
				}
				buf[1] = OLED_REG_SET_PAGEADDR | page; // page n
				if ((ret = i2c->write(channel, address, buf, 2)) != ESP_OK) {
					return ret;
				}

				p = vram;
				p += 16 * 8 * page;

				// render 1 line per page, 16*8 bytes
				for (i = 0; i < 8; i++) {
					buf[0] = 0x40; // data
					for (j = 1; j < 17; j++) {
						buf[j] = *p++;
					}
					if ((ret = i2c->write(channel, address, buf, 17)) != ESP_OK) {
						return ret;
					}
				}
			}
			break;
	}

	return ESP_OK;
}

void OLED_SH1106::process(Driver *drv) {
	I2CDev *i2c = (I2CDev *)drv;
	uint8_t buf[3], len;

	switch (state) {
		case s_detect:
			// detect i2c device
			if (i2c->detect(channel, address) == ESP_OK) {
				init_ptr = &oled_i2c_init_array[0];
				state = s_cmd_init;
			}
			else {
				state = s_error;
			}
			break;

		case s_cmd_init:
			if (init_ptr->command != -1) {
				buf[0] = 0; // command
				buf[1] = init_ptr->command;
				len = 2;
				if (init_ptr->data != -1) {
					buf[2] = init_ptr->data;
					len = 3;
				}
				// i2c write
				if (i2c->write(channel, address, buf, len) == ESP_OK) {
					init_ptr++;
				}
				else {
					state = s_error;
				}
			}
			else {
				// clear screen
				clear();
				// render
				if (render(i2c) == ESP_OK) {
					// display on
					buf[0] = 0; // command
					buf[1] = OLED_REG_DISPLAY_ON;
					if (i2c->write(channel, address, buf, 2) == ESP_OK) {
						// clear error flag
						error = false;
						// set initialized flag
						initialized = true;
						// goto idle state
						state = s_idle;
					}
					else {
						state = s_error;
					}
				}
				else {
					state = s_error;
				}
			}
			break;

		case s_idle:
			// check set/clr flag
			if (clr_flag & 0x7f) {
				FLAG_CLR(flag, clr_flag & 0x7f);
				clr_flag = 0;
			}
			if (set_flag & 0x7f) {
				FLAG_SET(flag, set_flag & 0x7f);
				set_flag = 0;
			}

			// check pending flag
			if (IS_FLAG_SET(flag, OLED_I2C_RENDER_FLAG)) {
				FLAG_CLR(flag, OLED_I2C_RENDER_FLAG);
				// render
				if (render(i2c) != ESP_OK) {
					state = s_error;
				}
			}
			break;

		case s_error:
			// set error flag
			error = true;
			// clear initialized flag
			initialized = false;
			// get current tickcnt
			tickcnt = get_tickcnt();
			// goto wait and retry with detect state
			state = s_wait;
			break;

		case s_wait:
			// delay 1000ms before retry detect
			if (is_tickcnt_elapsed(tickcnt, 1000)) {
				state = s_detect;
			}
			break;
	}
}

bool OLED_SH1106::valid_column_row(uint8_t lcd_column, uint8_t lcd_row) {
	// validate column,row (1-based)
	if (((lcd_column >= 1) && (lcd_column <= (OLED_I2C_WIDTH / 6))) && ((lcd_row >= 1) && (lcd_row <= (OLED_I2C_HEIGHT / 8)))) {
		return true;
	}

	return false;
}

bool OLED_SH1106::valid_column_row_big(uint8_t lcd_column, uint8_t lcd_row) {
	// validate column,row (1-based)
	if (((lcd_column >= 1) && (lcd_column <= ((OLED_I2C_WIDTH / 6) - 1))) && ((lcd_row >= 1) && (lcd_row <= ((OLED_I2C_HEIGHT / 8) - 1)))) {
		return true;
	}

	return false;
}

void OLED_SH1106::putch(uint8_t lcd_column, uint8_t lcd_row, char val) {
    int i, indx, buf_indx;

	if (!valid_column_row(lcd_column, lcd_row)) {
		return;
	}
	// change to zero based
	lcd_column--;
	lcd_row--;

	// font 6x8
	buf_indx = (lcd_row * OLED_I2C_WIDTH) + (lcd_column * 6);
    indx = val * 6;
    for (i = 0; i < 6; i++) {
		vram[buf_indx + i] = oled_font_6_8[indx];
        indx++;
    }

	// set render flag
	set_flag |= (0x80 | OLED_I2C_RENDER_FLAG);
}

void OLED_SH1106::putstr(uint8_t lcd_column, uint8_t lcd_row, char *str) {
	int i, indx, buf_indx;

	if (!valid_column_row(lcd_column, lcd_row)) {
		return;
	}
	// change to zero based
	lcd_column--;
	lcd_row--;

	// font 6x8
	buf_indx = (lcd_row * OLED_I2C_WIDTH) + (lcd_column * 6);
	while (*str) {
		indx = *str * 6;
		for (i = 0; i < 6; i++) {
			vram[buf_indx + i] = oled_font_6_8[indx];
			indx++;
		}
		str++;
		buf_indx += 6;
	}

	// set render flag
	set_flag |= (0x80 | OLED_I2C_RENDER_FLAG);
}

void OLED_SH1106::putstr(uint8_t lcd_column, uint8_t lcd_row, double val) {
	char buf[(OLED_I2C_WIDTH / 6) + 1];
	int i;

	snprintf(buf, (OLED_I2C_WIDTH / 6), "%.2f", val); // default precision = 2
	// check ending zero
	i = strlen(buf) - 1;
	while (i >= 0) {
		if (buf[i] == '0') {
			buf[i] = '\x0';
		}
		else
		if (buf[i] == '.') {
			buf[i] = '\x0';
			break;
		}
		else {
			break; // first occurence of non-zero or dot
		}
		i--;
	}

	putstr(lcd_column, lcd_row, buf);
}

void OLED_SH1106::putstr(uint8_t lcd_column, uint8_t lcd_row, double val, int precision) {
	char fmt[8];
	char buf[(OLED_I2C_WIDTH / 6) + 1];

	if (precision < 0) {
		strcpy(fmt, "%.0f");
	}
	else
	if (precision > 6) {
		strcpy(fmt, "%.6f");
	}
	else {
		snprintf(fmt, sizeof(fmt) - 1, "%%.%df", precision);
	}

	snprintf(buf, (OLED_I2C_WIDTH / 6), fmt, val);
	putstr(lcd_column, lcd_row, buf);
}

void OLED_SH1106::puthex(uint8_t lcd_column, uint8_t lcd_row, int val) {
	int dat;
	char str[3];

	dat = (val >> 4) & 0x0f;
	if ((dat >= 0) && (dat <= 9)) dat = 0x30 + dat;
	else dat = dat +0x37;
	str[0] = dat;

	dat = val & 0x0f;
	if ((dat >= 0) && (dat <= 9)) dat = 0x30 + dat;
	else dat = dat +0x37;
	str[1] = dat;

	str[2] = '\x0';
	putstr(lcd_row, lcd_column, &str[0]);
}

void OLED_SH1106::putch_big(uint8_t lcd_column, uint8_t lcd_row, char val) {
    int i, j, indx, buf_indx;

	if (!valid_column_row_big(lcd_column, lcd_row)) {
		return;
	}
	// change to zero based
	lcd_column--;
	lcd_row--;

	// font 12x16
	buf_indx = (2 * lcd_row * OLED_I2C_WIDTH) + (lcd_column * 12);
	indx = val * 24;
	j = 0;
	for (i = 0; i < 24; i = i + 2) {
		vram[buf_indx + j] = oled_font_12_16[indx + i];
		j++;
	}

	j = 0;
	for (i = 1; i < 24; i = i + 2) {
		vram[buf_indx + j + OLED_I2C_WIDTH] = oled_font_12_16[indx + i];
		j++;
	}

	// set render flag
	set_flag |= (0x80 | OLED_I2C_RENDER_FLAG);
}

void OLED_SH1106::putstr_big(uint8_t lcd_column, uint8_t lcd_row, char *str) {
	int i, j, indx, buf_indx;

	if (!valid_column_row_big(lcd_column, lcd_row)) {
		return;
	}
	// change to zero based
	lcd_column--;
	lcd_row--;

	// font 12x16
	buf_indx = (lcd_row * OLED_I2C_WIDTH) + (lcd_column * 6);
	while (*str) {
		indx = *str * 24;
		j = 0;
		for (i = 0; i < 24; i = i + 2)  {
			vram[buf_indx + j] = oled_font_12_16[indx + i];
			j++;
		}

		j = 0;
		for (i = 1; i < 24; i = i + 2) {
			vram[buf_indx + j + OLED_I2C_WIDTH] = oled_font_12_16[indx + i];
			j++;
		}

		str++;
		buf_indx += 12;
	}

	// set render flag
	set_flag |= (0x80 | OLED_I2C_RENDER_FLAG);
}

void OLED_SH1106::putstr_big(uint8_t lcd_column, uint8_t lcd_row, double val) {
	char buf[(OLED_I2C_WIDTH / 6) + 1];
	int i;

	snprintf(buf, (OLED_I2C_WIDTH / 6), "%.2f", val); // default precision = 2
	// check ending zero
	i = strlen(buf) - 1;
	while (i >= 0) {
		if (buf[i] == '0') {
			buf[i] = '\x0';
		}
		else
		if (buf[i] == '.') {
			buf[i] = '\x0';
			break;
		}
		else {
			break; // first occurence of non-zero or dot
		}
		i--;
	}

	putstr_big(lcd_column, lcd_row, buf);
}

void OLED_SH1106::putstr_big(uint8_t lcd_column, uint8_t lcd_row, double val, int precision) {
	char fmt[8];
	char buf[(OLED_I2C_WIDTH / 6) + 1];

	if (precision < 0) {
		strcpy(fmt, "%.0f");
	}
	else
	if (precision > 6) {
		strcpy(fmt, "%.6f");
	}
	else {
		snprintf(fmt, sizeof(fmt) - 1, "%%.%df", precision);
	}

	snprintf(buf, (OLED_I2C_WIDTH / 6), fmt, val);
	putstr_big(lcd_column, lcd_row, buf);
}
