#include "esp_system.h"
#include "kidbright32.h"
#include "zx_led.h"

ZX_LED::ZX_LED(gpio_num_t gpio) {
	gpio_num = gpio;
}

void ZX_LED::init(void) {
	gpio_config_t io_conf;
	// outputs init
	io_conf.intr_type = GPIO_INTR_DISABLE; // disable interrupt
	io_conf.mode = GPIO_MODE_OUTPUT; // set as output mode
	io_conf.pin_bit_mask = (1ULL << gpio_num); // pin bit mask
	io_conf.pull_down_en = GPIO_PULLDOWN_DISABLE; // disable pull-down mode
	io_conf.pull_up_en = GPIO_PULLUP_DISABLE; // disable pull-up mode
	status = 0;
	gpio_set_level(gpio_num, status); // active high
	gpio_config(&io_conf);

	// clear error flag
	error = false;
	// set initialized flag
	initialized = true;

	state = s_detect;
}

int ZX_LED::prop_count(void) {
	// not supported
	return 0;
}

bool ZX_LED::prop_name(int index, char *name) {
	// not supported
	return false;
}

bool ZX_LED::prop_unit(int index, char *unit) {
	// not supported
	return false;
}

bool ZX_LED::prop_attr(int index, char *attr) {
	// not supported
	return false;
}

bool ZX_LED::prop_read(int index, char *value) {
	// not supported
	return false;
}

bool ZX_LED::prop_write(int index, char *value) {
	// not supported
	return false;
}

void ZX_LED::process(Driver *drv) {
	switch (state) {
		case s_detect:
			break;

		case s_idle:
			break;
	}
}

void ZX_LED::out(int stat) {
	status = stat;

	gpio_set_level(gpio_num, stat); // active high
}

